// conversion from sRGB Reference White D65 ( color space used by windows ) to XYZ

vec3 srgb_2_xyz( vec3 c ) {

    //Inverse Companding
    vec3 v;
    v.r = ( c.r > 0.004045 ) ? ( pow(( c.r + 0.055)/1.055, 2.4 )) : c.r/12.92;
    v.g = ( c.g > 0.004045 ) ? ( pow(( c.g + 0.055)/1.055, 2.4 )) : c.g/12.92;
    v.b = ( c.b > 0.004045 ) ? ( pow(( c.b + 0.055)/1.055, 2.4 )) : c.b/12.92;

    return v *
        mat3(  0.4124564,  0.3575761,  0.1804375,
	       0.2126729,  0.7151522,  0.0721750,
	       0.0193339,  0.1191920,  0.9503041 );
}

// conversion from XYZ to sRGB Reference White D65 ( color space used by windows ) 

vec3 xyz_2_srgb( vec3 c ) {

    vec3 v =  c *         
	mat3(  3.2404542, -1.5371385, -0.4985314,
	      -0.9692660,  1.8760108,  0.0415560,
 	       0.0556434, -0.2040259,  1.0572252 );

    //Companding
    v.r = ( v.r > 0.0031308 ) ? (( 1.055 * pow( v.r, ( 1.0 / 2.4 ))) - 0.055 ) : 12.92 * v.r;
    v.g = ( v.g > 0.0031308 ) ? (( 1.055 * pow( v.g, ( 1.0 / 2.4 ))) - 0.055 ) : 12.92 * v.g;
    v.b = ( v.b > 0.0031308 ) ? (( 1.055 * pow( v.b, ( 1.0 / 2.4 ))) - 0.055 ) : 12.92 * v.b;
}